import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import numpy as np
import tkinter.filedialog as fd
import numpy.polynomial.polynomial as npp

t = [-25., 0., 50., 100., 150., 200., 250., 300., 350., 400.]
v = [-0.968, 0., 2.023, 4.096, 6.138, 8.138, 10.153, 12.209, 14.293, 16.397]

root = gc.create_window(title='Thermocouple Data Fit Plot', size='1000x600')
control_box, right_frame = gc.create_frames(root)
ax, canvas = pc.create_plot(right_frame)

pc.update_plot(ax, canvas, v, t,
               label_x='Therocouple Voltage (mV)',
               label_y='Temperature (deg Celsius)',
               marker='o')


coef = npp.polyfit(v, t, 9)
a_0, a_1, a_2, a_3, a_4, a_5, a_6, a_7, a_8, a_9 = coef

print(coef)
gc.create_indicator(control_box, label_1='a_1',
                    label_2=f'{a_1:.8e}')
gc.create_indicator(control_box, label_1='a_2',
                    label_2=f'{a_2:.8e}')
gc.create_indicator(control_box, label_1='a_3',
                    label_2=f'{a_3:.8e}')
gc.create_indicator(control_box, label_1='a_4',
                    label_2=f'{a_4:.8e}')
gc.create_indicator(control_box, label_1='a_5',
                    label_2=f'{a_5:.8e}')
gc.create_indicator(control_box, label_1='a_6',
                    label_2=f'{a_6:.8e}')
gc.create_indicator(control_box, label_1='a_7',
                    label_2=f'{a_7:.8e}')
gc.create_indicator(control_box, label_1='a_8',
                    label_2=f'{a_8:.8e}')
gc.create_indicator(control_box, label_1='a_9',
                    label_2=f'{a_9:.8e}')

v = np.linspace(-1, 17, 1000)
t_fit = (a_0 + a_1*v + a_2*v**2 + a_3*v**3 + a_4*v**4 + a_5*v**5
        + a_6*v**6 + a_7*v**7 + a_8*v**8 + a_9*v**9)

pc.update_plot(ax, canvas, v, t_fit,
               label_x='Therocouple Voltage (mV)',
               label_y='Temperature (deg Celsius)',
               clear_flag=False)

